﻿Shader "!FullControl/Effects/Refractive Simple" {

Properties 
{
    _Color ("Main Color", Color) = (1,1,1,0.5)
    _MainInt ("Main Intesity", Float) = 1
    _MainTex ("Pan Texture (RGB) | Mask (A)", 2D) = "white" { }
	_RefrColor ("Refraction Color", Color) = (1,1,1,1)
	_RefrIntensity ("Refraction Intensity", float) = 1.5
	_RefrDist  ("Refraction Distortion", range (0,50)) = 50
	
	//_BumpMap ("Normal Map", 2D) = "bump" {}
}

SubShader 
{
   		Tags {"Queue"="Transparent"}
		Blend SrcAlpha OneMinusSrcAlpha
		
		//ZWrite Off Fog {Color (0,0,0,0)}
		
		GrabPass 
		{							
			Name "BASE"
			Tags { "LightMode" = "Always" }
 		}
		
   		Pass 
   		{
  		Name "BASE"
		Tags { "LightMode" = "Always" }
		
		CGPROGRAM
		#pragma exclude_renderers d3d11 xbox360
		#pragma vertex vert
		#pragma fragment frag
		#include "UnityCG.cginc"

		uniform float4 _Color;
		uniform sampler2D _MainTex;
		uniform float4 _MainTex_ST;
		uniform float _MainInt;
		
		uniform	sampler2D _GrabTexture;
		uniform float4 _GrabTexture_TexelSize;
		uniform float4 _RefrColor;
		uniform float _RefrIntensity;
		uniform float _RefrDist;
	//	uniform sampler2D _BumpMap;

		struct v2f 
		{
			//float4 vertex : POSITION;
		    float4  pos : POSITION; //SV_POSITION
		    float2  uv : TEXCOORD0;
		    float4 	vertColor;
		    fixed4 color : COLOR;
		    float4 uvgrab : TEXCOORD1;
		    float2 uvbump : TEXCOORD2;
		};
		float4 _BumpMap_ST;
		
		v2f vert (appdata_full v)
		{
		    v2f o;
		    #if UNITY_UV_STARTS_AT_TOP
			float scale = -1.0;
			#else
			float scale = 1.0;
			#endif
		    o.pos = mul (UNITY_MATRIX_MVP, v.vertex);
			o.uv = TRANSFORM_TEX (v.texcoord, _MainTex);
			o.color = v.color;
			
			o.uvgrab.xy = (float2(o.pos.x, o.pos.y * scale) + o.pos.w) * 0.5;
			o.uvgrab.zw = o.pos.zw;
			//o.uvbump = TRANSFORM_TEX (v.texcoord, _BumpMap);
			
		    return o;
		}
		
		half4 frag (v2f i) : COLOR
		{
			fixed4 textRGB = tex2D (_MainTex, i.uv);
			
			fixed textA = tex2D (_MainTex, i.uv);
			fixed mask = textA;
			fixed4 finalColor = textA * _Color;
			
			float2 offset = textA * _RefrDist * _GrabTexture_TexelSize.xy;
			i.uvgrab.xy = offset * i.uvgrab.z + i.uvgrab.xy;	
			half4 refr = tex2Dproj(_GrabTexture, UNITY_PROJ_COORD(i.uvgrab));
			
			half4 finalRefr = refr * _RefrColor * _RefrIntensity;
			finalRefr.a = textA.r * _MainInt * i.color;
			
			return finalRefr;
			//return (finalColor + finalRefr) * mask;
		}
		
		ENDCG
	}
}
//Fallback "VertexLit"
} 
